//==============================================================================
// Project:		Wealth Transfers and their Economic Effects
// File name:	Youth in Focus Comparison
// Objective: 	Calculating HILDA statistics that are comparable to those
//				reported in Cobb-Clark and Gorgens (2011) based on the Youth in
//				Focus dataset.
//
// Created: 	16/04/2021
// Modified: 	15/11/2021
//==============================================================================

*************************************
*** Loading and cleaning the data ***
*************************************

clear

cd "XXXX"	// set the content directory here

use HILDA_restricted_combined_rescaled	// importing the unconfidentialised HILDA data for waves 1-19 that includes the new weights for residents of non-private dwellings

keep if (hgage == 18 & wave == 6 | hgage == 20 & wave == 8)	// keeping waves and individuals that line up with the waves of the YIF survey

gen gift = 0	// generating a gift variable
replace gift = oifpnta if oifpnta > 0	// replacing the gift variable equal to positive values of transfers from parents

drop if fmagelh < 10	// dropping non-responding persons and other respondents with missing variables

* living at home indicator variable
gen living_at_home = 0
replace living_at_home = 1 if fmagelh == 99

*********************
*** Data analysis ***
*********************

keep wave living_at_home hhwtrp benchmarked_new_hhwtrp gift

by wave living_at_home, sort: sum gift [w=benchmarked_new_hhwtrp]

gen mean_gift = .
gen median_gift = .

sum gift [w=benchmarked_new_hhwtrp] if gift>0 & wave==6 & living_at_home==0, detail
replace mean_gift = r(mean) 		if gift>0 & wave==6 & living_at_home==0
replace median_gift = r(p50) 		if gift>0 & wave==6 & living_at_home==0

sum gift [w=benchmarked_new_hhwtrp] if gift>0 & wave==6 & living_at_home==1, detail
replace mean_gift = r(mean)			if gift>0 & wave==6 & living_at_home==1
replace median_gift = r(p50) 		if gift>0 & wave==6 & living_at_home==1

sum gift [w=benchmarked_new_hhwtrp] if gift>0 & wave==8 & living_at_home==0, detail
replace mean_gift = r(mean) 		if gift>0 & wave==8 & living_at_home==0
replace median_gift = r(p50) 		if gift>0 & wave==8 & living_at_home==0

sum gift [w=benchmarked_new_hhwtrp] if gift>0 & wave==8 & living_at_home==1, detail
replace mean_gift = r(mean) 		if gift>0 & wave==8 & living_at_home==1
replace median_gift = r(p50) 		if gift>0 & wave==8 & living_at_home==1

by wave living_at_home, sort: egen recipients = sum(benchmarked_new_hhwtrp) if gift >0 // calculating number of gift recipients by group
by wave living_at_home, sort: egen population = sum(benchmarked_new_hhwtrp) // calculating population by group
by wave living_at_home, sort: gen proportion = recipients / population	// calculating the proportion that received a gift by wave and living status

gen combined_mean = .
gen combined_median = .

sum gift [w=benchmarked_new_hhwtrp] if gift>0 & wave==6, detail
replace combined_mean = r(mean)		if gift>0 & wave==6
replace combined_median = r(p50)	if gift>0 & wave==6

sum gift [w=benchmarked_new_hhwtrp] if gift>0 & wave==8, detail
replace combined_mean = r(mean)		if gift>0 & wave==8
replace combined_median = r(p50)	if gift>0 & wave==8

by wave, sort: egen combined_recipients = sum(benchmarked_new_hhwtrp) if gift >0 // calculating number of gift recipients by wave
by wave, sort: egen combined_population = sum(benchmarked_new_hhwtrp) // calculating population by wave

collapse median_gift mean_gift recipients population proportion combined_*, by(wave living_at_home)	// collapsing the dataset to leave the key variables

by wave, sort: gen combined_proportion = combined_recipients / combined_population

drop combined_population combined_recipients recipients population

save YIF_comparison.dta, replace	// saving the dataset